/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class ListStepped
implements LongFunction<List<Object>> {
    private final List<LongFunction<? extends Object>> valueFuncs;
    private final int size;

    @Example(value={"ListFunctions(NumberNameToString(),NumberNameToString())", "Create a list of ['one','one']"})
    public ListStepped(LongFunction<? extends Object> ... funcs) {
        this.valueFuncs = Arrays.asList(funcs);
        this.size = this.valueFuncs.size();
    }

    @Example(value={"ListFunctions(NumberNameToString(),NumberNameToString())", "Create a list of ['one','one']"})
    public ListStepped(LongUnaryOperator ... funcs) {
        ArrayList<LongFunction<? extends Object>> building = new ArrayList<LongFunction<? extends Object>>(funcs.length);
        for (LongUnaryOperator func : funcs) {
            building.add(func::applyAsLong);
        }
        this.valueFuncs = building;
        this.size = building.size();
    }

    @Example(value={"ListFunctions(NumberNameToString(),NumberNameToString())", "Create a list of ['one','one']"})
    public ListStepped(Function<Long, Object> ... funcs) {
        ArrayList<LongFunction<? extends Object>> building = new ArrayList<LongFunction<? extends Object>>(funcs.length);
        for (Function<Long, Object> func : funcs) {
            building.add(func::apply);
        }
        this.valueFuncs = building;
        this.size = building.size();
    }

    @Override
    public List<Object> apply(long value) {
        ArrayList<Object> list = new ArrayList<Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            int selector = Math.min(i, this.valueFuncs.size() - 1);
            LongFunction<? extends Object> func = this.valueFuncs.get(selector);
            list.add(func.apply(value + (long)i));
        }
        return list;
    }
}

