/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class StringList
implements LongFunction<List<String>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> valueFunc;

    @Example(value={"StringList(HashRange(3,7),Add(15L))", "create a list between 3 and 7 elements of String representations of Long values"})
    public StringList(LongToIntFunction sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc;
    }

    @Override
    public List<String> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.valueFunc.apply(value + (long)i).toString());
        }
        return list;
    }
}

