/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class HashRange
implements LongUnaryOperator {
    private final long minValue;
    private final long width;
    private final Hash hash = new Hash();

    public HashRange(long width) {
        this.minValue = 0L;
        this.width = width;
    }

    public HashRange(long minValue, long maxValue) {
        this.minValue = minValue;
        if (maxValue <= minValue) {
            throw new RuntimeException("HashRange must have min and max value in that order.");
        }
        this.width = maxValue - minValue;
    }

    @Override
    public long applyAsLong(long operand) {
        return this.minValue + this.hash.applyAsLong(operand) % this.width;
    }
}

