/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_double.HashedDoubleRange;
import java.util.ArrayList;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class WeightedLongs
implements LongFunction<Long> {
    private final String valuesAndWeights;
    private double[] unitWeights;
    private double[] cumulativeWeights;
    private HashedDoubleRange unitRange = new HashedDoubleRange(0.0, 1.0);
    private long[] values;

    @Examples(value={@Example(value={"WeightedLongs('1:10;3;5;12345;1", "Yield 1 62.5% of the time, 3 31.25% of the time, and 12345 6.2% of the time"}), @Example(value={"WeightedLongs('1,6,7", "Yield 1 33.3% of the time, 6 33.3% of the time, and 7 33.3% of the time"})})
    public WeightedLongs(String valuesAndWeights) {
        this.valuesAndWeights = valuesAndWeights;
        this.parseWeights();
    }

    private void parseWeights() {
        String[] pairs = this.valuesAndWeights.split(";");
        if (pairs.length == 0) {
            throw new RuntimeException("No pairs were found. They must be separated by ';'");
        }
        String[] fragments = new String[pairs.length];
        ArrayList<Double> parsedWeights = new ArrayList<Double>();
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i].split(":", 2);
            if (pair.length == 2) {
                parsedWeights.add(Double.valueOf(pair[1].trim()));
            } else {
                parsedWeights.add(1.0);
            }
            this.values[i] = Long.parseLong(pair[0].trim());
        }
        double total = parsedWeights.stream().mapToDouble(f -> f).sum();
        this.unitWeights = parsedWeights.stream().mapToDouble(f -> f / total).toArray();
        this.cumulativeWeights = new double[this.unitWeights.length];
        double cumulative = 0.0;
        for (int i = 0; i < this.unitWeights.length; ++i) {
            this.cumulativeWeights[i] = cumulative += this.unitWeights[i];
        }
    }

    @Override
    public Long apply(long value) {
        double sampledUnit = this.unitRange.applyAsDouble(value);
        for (int i = 0; i < this.cumulativeWeights.length; ++i) {
            if (!(sampledUnit < this.cumulativeWeights[i])) continue;
            return this.values[i];
        }
        throw new RuntimeException("sampled value '" + sampledUnit + "' was not below final cumulative weight: " + this.cumulativeWeights[this.cumulativeWeights.length - 1]);
    }
}

