/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_object;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataFunctions;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.AliasSamplerDoubleInt;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.EvProbD;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_double.HashedDoubleRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.LongFunction;

@Categories(value={Category.distributions})
@ThreadSafeMapper
public class WeightedFuncs
implements LongFunction<Object> {
    private final LongFunction<Object>[] funcs;
    private final AliasSamplerDoubleInt functionSampler;
    private HashedDoubleRange unitSampler = new HashedDoubleRange(0.0, 1.0);

    public WeightedFuncs(Object ... weightsAndFuncs) {
        ArrayList<EvProbD> probabilites = new ArrayList<EvProbD>();
        ArrayList<LongFunction> functions = new ArrayList<LongFunction>();
        ArrayList probabilities = new ArrayList();
        if (weightsAndFuncs.length % 2 != 0) {
            throw new RuntimeException("You must have weights and functions, pairwise.This is not possible with " + Arrays.toString(weightsAndFuncs));
        }
        for (int i = 0; i < weightsAndFuncs.length; i += 2) {
            Object w = weightsAndFuncs[i];
            double weight = 1.0;
            try {
                weight = (Double)w;
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("the 0th and ever even value must be a floating point weight.");
            }
            probabilites.add(new EvProbD(i >> 1, weight));
            Object f = weightsAndFuncs[i + 1];
            try {
                LongFunction func = VirtDataFunctions.adapt(f, LongFunction.class, Object.class, true);
                functions.add(func);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("There was a problem resolving function " + f);
            }
        }
        this.funcs = functions.toArray(new LongFunction[0]);
        this.functionSampler = new AliasSamplerDoubleInt(probabilites);
    }

    @Override
    public Object apply(long value) {
        double univariate = this.unitSampler.applyAsDouble(value);
        int index = this.functionSampler.applyAsInt(univariate);
        LongFunction<Object> func = this.funcs[index];
        Object result = func.apply(value);
        return result;
    }
}

