/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.HashRange;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
public class HashedFileExtractToString
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(HashedFileExtractToString.class);
    private static CharBuffer fileDataImage = null;
    private final HashRange sizeRange;
    private final HashRange positionRange;
    private int minsize;
    private int maxsize;
    private final String fileName;

    @Example(value={"HashedFileExtractToString('data/adventures.txt',100,200)", "return a fragment from adventures.txt between 100 and 200 characters long"})
    public HashedFileExtractToString(String fileName, int minsize, int maxsize) {
        this.fileName = fileName;
        this.minsize = minsize;
        this.maxsize = maxsize;
        this.loadData();
        this.sizeRange = new HashRange(minsize, maxsize);
        this.positionRange = new HashRange(1, fileDataImage.limit() - maxsize - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadData() {
        if (fileDataImage != null) return;
        Class<HashedFileExtractToString> clazz = HashedFileExtractToString.class;
        synchronized (HashedFileExtractToString.class) {
            CharBuffer image;
            if (fileDataImage != null) return;
            fileDataImage = image = NBIO.readCharBuffer(this.fileName, new String[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String apply(long input) {
        int offset = this.positionRange.applyAsInt(input);
        int length = this.sizeRange.applyAsInt(input);
        String sub = null;
        try {
            sub = fileDataImage.subSequence(offset, offset + length).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sub;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.minsize + ":" + this.maxsize;
    }
}

