/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.HashRange;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
public class HashedLineToString
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(HashedLineToString.class);
    private final HashRange indexRange;
    private List<String> lines = new ArrayList<String>();
    private final String filename;

    public HashedLineToString(String filename) {
        this.filename = filename;
        this.lines = NBIO.readLines(filename);
        this.indexRange = new HashRange(0, this.lines.size() - 2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public String apply(long operand) {
        int itemIdx = this.indexRange.applyAsInt(operand);
        String item = this.lines.get(itemIdx);
        return item;
    }
}

