/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_string.ModuloLineToString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
public class ModuloCSVLineToString
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(ModuloLineToString.class);
    private List<String> lines = new ArrayList<String>();
    private String filename;

    @Example(value={"ModuloCSVLineToString('data/myfile.csv','lat')", "load values for 'lat' from the CSV file myfile.csv."})
    public ModuloCSVLineToString(String filename, String fieldname) {
        this.filename = filename;
        CSVParser csvp = NBIO.readFileCSV(filename, new String[0]);
        Map<String, Integer> headerMap = csvp.getHeaderMap();
        if (headerMap == null || headerMap.isEmpty()) {
            throw new RuntimeException("There were not headers for file " + filename + ". " + ModuloCSVLineToString.class.getSimpleName() + " requires headers.");
        }
        Integer column = headerMap.get(fieldname);
        if (column == null) {
            throw new RuntimeException("Could not find the named column header '" + fieldname + "' in file " + filename);
        }
        for (CSVRecord strings : csvp) {
            this.lines.add(strings.get(column));
        }
    }

    @Override
    public String apply(long input) {
        int itemIdx = (int)(input % (long)this.lines.size()) % Integer.MAX_VALUE;
        String item = this.lines.get(itemIdx);
        return item;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }
}

