/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class TemplateAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "Template";
    }

    @Override
    public String getPackageName() {
        return "io.nosqlbench.virtdata.library.basics.shared.from_long.to_string";
    }

    @Override
    public String getClassJavadoc() {
        return "Creates a template function which will yield a string which fits the template\nprovided, with all occurrences of <code>{}</code> substituted pair-wise with the\nresult of the provided functions. The number of <code>{}</code> entries in the template\nmust strictly match the number of functions or an error will be thrown.\n\nIf you need to include single quotes or other special characters, you may use a\nbackslash \"\\\" in your template.\n\nThe objects passed must be functions of any of the following types:\n<UL>\n    <LI>LongUnaryOperator</LI>\n    <LI>IntUnaryOperator</LI>\n    <LI>DoubleUnaryOperator</LI>\n    <LI>LongFunction</LI>\n    <LI>IntFunction</LI>\n    <LI>DoubleFunction</LI>\n    <LI>Function&lt;Long,?&gt;</LI>\n</UL>\n\n<p>The result of applying the input value to any of these functions is converted to a String\nand then stitched together according to the template provided.</p>\n";
    }

    @Override
    public String getInType() {
        return "long";
    }

    @Override
    public String getOutType() {
        return "java.lang.String";
    }

    @Override
    public Category[] getCategories() {
        return new Category[0];
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("Template", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("template", "java.lang.String");
                        this.put("funcs", "java.lang.Object[]...");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("Template('{}-{}',Add(10),Hash())");
                                this.add("concatenate input+10, '-', and a pseudo-random long");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("Template", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("truncate", "boolean");
                        this.put("template", "java.lang.String");
                        this.put("funcs", "java.lang.Object[]...");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("Template(true, '{}-{}', Add(10),Hash())");
                                this.add("throws an error, as the Add(10) function causes a narrowing conversion for a long input");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("Template", "If an operator is provided, it is used to change the function input value in an additional way before each function.\n\n@param iterOp   A pre-generation value mapping function\n@param template A string template containing <pre>{}</pre> anchors\n@param funcs    A varargs length of LongFunctions of any output type\n", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("iterOp", "java.util.function.LongUnaryOperator");
                        this.put("template", "java.lang.String");
                        this.put("funcs", "java.util.function.LongFunction<?>[]...");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){}));
            }
        };
    }
}

