/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_time_types;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.Date;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class ToDate
implements LongFunction<Date> {
    private long spacing;
    private long repeat_count;

    public ToDate(int spacing, int repeat_count) {
        this.spacing = spacing;
        this.repeat_count = repeat_count;
    }

    public ToDate(int spacing) {
        this(spacing, 1);
    }

    public ToDate() {
        this.spacing = 1L;
        this.repeat_count = 1L;
    }

    @Override
    public Date apply(long input) {
        input = input * this.spacing / this.repeat_count;
        return new Date(input);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.spacing + ":" + this.repeat_count;
    }
}

