/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_time_types.joda;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_time_types.joda.Timezones;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class ToMillisAtStartOfMonth
implements LongUnaryOperator {
    private final DateTimeZone tz;

    @Example(value={"ToMillisAtStartOfMonth()", "return millisecond epoch time of the start of the month of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfMonth() {
        this(DateTimeZone.UTC.getID());
    }

    @Example(value={"ToMillisAtStartOfMonth('America/Chicago')", "return millisecond epoch time of the start of the month of the provided millisecond epoch time, using timezone America/Chicago"})
    public ToMillisAtStartOfMonth(String timezoneId) {
        this.tz = Timezones.forId(timezoneId);
    }

    @Override
    public long applyAsLong(long operand) {
        return new DateTime(operand, this.tz).withTimeAtStartOfDay().withDayOfMonth(1).getMillis();
    }
}

