/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_uuid;

import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.UUID;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class ToHashedUUID
implements LongFunction<UUID> {
    private Hash longHash = new Hash();

    @Override
    public UUID apply(long value) {
        long msbs = this.longHash.applyAsLong(value);
        long lsbs = this.longHash.applyAsLong(value + 1L);
        msbs = msbs & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        lsbs = lsbs & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        UUID uuid = new UUID(msbs, lsbs);
        return uuid;
    }
}

