/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_string.to_epoch;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class DateTimeParser
implements Function<String, DateTime> {
    private final DateTimeFormatter dateTimeFormatter;
    private final DateTime defaultTime;

    @Example(value={"DateTimeParser()", "parse any date in the yyyy-MM-dd HH:mm:ss.SSSZ format"})
    public DateTimeParser() {
        this("yyyy-MM-dd HH:mm:ss.SSSZ", null);
    }

    @Example(value={"DateTimeParser('yyyy-MM-dd')", "parse any date in the yyyy-MM-dd format"})
    public DateTimeParser(String dateTimePattern) {
        this(dateTimePattern, null);
    }

    @Example(value={"DateTimeParser('yyyy-MM-dd','1999-12-31')", "parse any date in the yyyy-MM-dd format, or return the DateTime represented by 1999-12-31"})
    public DateTimeParser(String dateTimePattern, String defaultTime) {
        this.dateTimeFormatter = DateTimeFormat.forPattern(dateTimePattern).withChronology(GregorianChronology.getInstance());
        if (defaultTime != null) {
            try {
                this.defaultTime = this.dateTimeFormatter.parseDateTime(defaultTime);
            }
            catch (Exception e) {
                throw new RuntimeException("DateTimeParser with pattern '" + dateTimePattern + "' did  not validate with default provided: '" + defaultTime + "'");
            }
        } else {
            this.defaultTime = null;
        }
    }

    @Override
    public DateTime apply(String formattedDateTime) {
        try {
            DateTime dateTime = this.dateTimeFormatter.parseDateTime(formattedDateTime);
            return dateTime;
        }
        catch (Exception e) {
            if (this.defaultTime != null) {
                return this.defaultTime;
            }
            throw new RuntimeException("Failed to parse '" + formattedDateTime + "' with '" + this.dateTimeFormatter + "'");
        }
    }
}

