/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_string.to_epoch;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class DateTimeParserAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "DateTimeParser";
    }

    @Override
    public String getPackageName() {
        return "io.nosqlbench.virtdata.library.basics.shared.from_string.to_epoch";
    }

    @Override
    public String getClassJavadoc() {
        return "This function will parse a String containing a formatted\ndate time, yielding a DateTime object.\n\nIf no arguments are provided, then the format is set to\n<pre>yyyy-MM-dd HH:mm:ss.SSSZ</pre>.\n\nFor details on formatting options, see @see <a href=\"https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html\">DateTimeFormat</a>\n";
    }

    @Override
    public String getInType() {
        return "java.lang.String";
    }

    @Override
    public String getOutType() {
        return "org.joda.time.DateTime";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.datetime};
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("DateTimeParser", "Initialize the parser with the default pattern of <pre>yyyy-MM-dd HH:mm:ss.SSSZ</pre>.\n", (Map<String, String>)new LinkedHashMap<String, String>(){}, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("DateTimeParser()");
                                this.add("parse any date in the yyyy-MM-dd HH:mm:ss.SSSZ format");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("DateTimeParser", "Initialize the parser with the given pattern. With this form, if any input fails to parse,\nor is null or empty, then an exception is thrown.\n@param dateTimePattern The pattern which represents the incoming format.\n", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("dateTimePattern", "java.lang.String");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("DateTimeParser('yyyy-MM-dd')");
                                this.add("parse any date in the yyyy-MM-dd format");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("DateTimeParser", "Initialize the parser with the given pattern and default value. In this form, if any\ninput fails to parse, then exceptions are suppressed and the default is provided instead.\nAt initialization, the default is parsed as a sanity check.\n@param dateTimePattern The pattern which represents the incoming format.\n@param defaultTime An example of a formatted datetime string which is used as a default.\n", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("dateTimePattern", "java.lang.String");
                        this.put("defaultTime", "java.lang.String");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("DateTimeParser('yyyy-MM-dd','1999-12-31')");
                                this.add("parse any date in the yyyy-MM-dd format, or return the DateTime represented by 1999-12-31");
                            }
                        });
                    }
                }));
            }
        };
    }
}

