/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.stateful;

import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.core.config.ConfigAware;
import io.nosqlbench.virtdata.core.config.ConfigModel;
import io.nosqlbench.virtdata.core.config.MutableConfigModel;
import java.util.Map;
import java.util.function.Function;

@ThreadSafeMapper
public class LoadElement
implements Function<Object, Object>,
ConfigAware {
    private final String varname;
    private final Object defaultValue;
    private final String mapname;
    private Map<String, ?> vars;

    @Example(value={"LoadElement('varname','vars','defaultvalue')", "Load the varable 'varname' from a map named 'vars', or provide 'defaultvalue' if neither is provided"})
    public LoadElement(String varname, String mapname, Object defaultValue) {
        this.mapname = mapname;
        this.varname = varname;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object apply(Object o) {
        if (this.vars == null) {
            return this.defaultValue;
        }
        Object object = this.vars.get(this.varname);
        return object != null ? object : this.defaultValue;
    }

    @Override
    public void applyConfig(Map<String, ?> elements) {
        Map vars = (Map)elements.get(this.mapname);
        if (vars != null) {
            this.vars = vars;
        }
    }

    @Override
    public ConfigModel getConfigModel() {
        return new MutableConfigModel().add("<mapname>", Map.class);
    }
}

