/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.continuous.common;

import io.nosqlbench.virtdata.library.curves4.discrete.common.ThreadSafeHash;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongToDoubleFunction;

public class RealLongDoubleSampler
implements LongToDoubleFunction {
    private final DoubleUnaryOperator f;
    private final boolean clamp;
    private final double clampMax;
    private ThreadSafeHash hash;

    public RealLongDoubleSampler(DoubleUnaryOperator parentFunc, boolean hash, boolean clamp, double clampMax) {
        this.f = parentFunc;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
        this.clamp = clamp;
        this.clampMax = clampMax;
    }

    @Override
    public double applyAsDouble(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        double sample = this.clamp ? Double.min(this.clampMax, this.f.applyAsDouble(unit)) : this.f.applyAsDouble(unit);
        return sample;
    }
}

