/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.discrete.common;

import io.nosqlbench.virtdata.library.curves4.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.LongUnaryOperator;

public class DiscreteLongLongSampler
implements LongUnaryOperator {
    private final DoubleToIntFunction f;
    private ThreadSafeHash hash;

    public DiscreteLongLongSampler(DoubleToIntFunction parentFunc, boolean hash) {
        this.f = parentFunc;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
    }

    @Override
    public long applyAsLong(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        int sample = this.f.applyAsInt(unit);
        return sample;
    }
}

