/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.discrete.common;

import io.nosqlbench.virtdata.library.curves4.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.LongToIntFunction;

public class InterpolatingLongIntSampler
implements LongToIntFunction {
    private final double[] lut;
    private final DoubleToIntFunction f;
    private int resolution;
    private ThreadSafeHash hash;

    public InterpolatingLongIntSampler(DoubleToIntFunction icdSource, int resolution, boolean hash) {
        this.f = icdSource;
        this.resolution = resolution;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
        this.lut = this.precompute();
    }

    private double[] precompute() {
        double[] precomputed = new double[this.resolution + 2];
        for (int s = 0; s <= this.resolution; ++s) {
            double rangedToUnit = (double)s / (double)this.resolution;
            int sampleValue = this.f.applyAsInt(rangedToUnit);
            precomputed[s] = sampleValue;
        }
        precomputed[precomputed.length - 1] = 0.0;
        return precomputed;
    }

    @Override
    public int applyAsInt(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        double samplePoint = unit * (double)this.resolution;
        int leftidx = (int)samplePoint;
        double leftPartial = samplePoint - (double)leftidx;
        double leftComponent = this.lut[leftidx] * (1.0 - leftPartial);
        double rightComponent = this.lut[leftidx + 1] * leftPartial;
        double sample = leftComponent + rightComponent;
        return (int)sample;
    }
}

