/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.discrete.int_int;

import io.nosqlbench.virtdata.library.curves4.discrete.common.DiscreteIntIntSampler;
import io.nosqlbench.virtdata.library.curves4.discrete.common.IntegerDistributionICDSource;
import io.nosqlbench.virtdata.library.curves4.discrete.common.InterpolatingIntIntSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.IntUnaryOperator;
import org.apache.commons.statistics.distribution.DiscreteDistribution;

public class IntToIntDiscreteCurve
implements IntUnaryOperator {
    private DiscreteDistribution distribution;
    private IntUnaryOperator function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(IntToIntDiscreteCurve.COMPUTE);
            this.add(IntToIntDiscreteCurve.INTERPOLATE);
            this.add(IntToIntDiscreteCurve.MAP);
            this.add(IntToIntDiscreteCurve.HASH);
        }
    };

    public IntToIntDiscreteCurve(DiscreteDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        IntegerDistributionICDSource icdSource = new IntegerDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        this.function = interpolate ? new InterpolatingIntIntSampler(icdSource, 1000, hash) : new DiscreteIntIntSampler(icdSource, hash);
    }

    @Override
    public int applyAsInt(int operand) {
        return this.function.applyAsInt(operand);
    }
}

