/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.discrete.int_long;

import io.nosqlbench.virtdata.library.curves4.discrete.common.DiscreteIntLongSampler;
import io.nosqlbench.virtdata.library.curves4.discrete.common.IntegerDistributionICDSource;
import io.nosqlbench.virtdata.library.curves4.discrete.common.InterpolatingIntLongSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.IntToLongFunction;
import org.apache.commons.statistics.distribution.DiscreteDistribution;

public class IntToLongDiscreteCurve
implements IntToLongFunction {
    private DiscreteDistribution distribution;
    private IntToLongFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(IntToLongDiscreteCurve.COMPUTE);
            this.add(IntToLongDiscreteCurve.INTERPOLATE);
            this.add(IntToLongDiscreteCurve.MAP);
            this.add(IntToLongDiscreteCurve.HASH);
        }
    };

    public IntToLongDiscreteCurve(DiscreteDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        IntegerDistributionICDSource icdSource = new IntegerDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        this.function = interpolate ? new InterpolatingIntLongSampler(icdSource, 1000, hash) : new DiscreteIntLongSampler(icdSource, hash);
    }

    @Override
    public long applyAsLong(int value) {
        return this.function.applyAsLong(value);
    }
}

