/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.DeprecatedFunction;
import java.util.List;
import java.util.function.LongToIntFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomLineToInt
implements LongToIntFunction {
    private static final Logger logger = LogManager.getLogger(RandomLineToInt.class);
    private final List<String> lines;
    private final MersenneTwister rng;
    private final IntegerDistribution itemDistribution;
    private final String filename;

    public RandomLineToInt(String filename) {
        this(filename, System.nanoTime());
    }

    public RandomLineToInt(String filename, long seed) {
        this.filename = filename;
        this.lines = NBIO.readLines(filename);
        this.rng = new MersenneTwister(seed);
        this.itemDistribution = new UniformIntegerDistribution(this.rng, 0, this.lines.size() - 2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public int applyAsInt(long value) {
        int itemIdx = this.itemDistribution.sample();
        String item = this.lines.get(itemIdx);
        return Integer.valueOf(item);
    }
}

