/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.virtdata.api.annotations.DeprecatedFunction;
import io.nosqlbench.virtdata.core.bindings.DataMapper;
import org.apache.commons.math3.random.MersenneTwister;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomRangedToDouble
implements DataMapper<Double> {
    private final MersenneTwister theTwister;
    private final long min;
    private final long max;
    private final long length;

    public RandomRangedToDouble(long min, long max) {
        this(min, max, System.nanoTime());
    }

    public RandomRangedToDouble(long min, long max, long seed) {
        this.theTwister = new MersenneTwister(seed);
        if (max <= min) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = min;
        this.max = max;
        this.length = max - min;
    }

    @Override
    public Double get(long input) {
        Double value = Math.abs(this.theTwister.nextDouble());
        value = value % (double)this.length;
        value = value + (double)this.min;
        return value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }
}

