/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.apps.valuesapp;

import io.nosqlbench.virtdata.core.bindings.DataMapper;
import io.nosqlbench.virtdata.core.bindings.VirtData;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValuesCheckerRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(ValuesCheckerRunnable.class);
    private final Condition goTime;
    private final Lock lock;
    private final long start;
    private final long end;
    private final List<Object> expected;
    private final DataMapper mapper;
    private final int threadNum;
    private final ConcurrentLinkedQueue<Integer> readyQueue;
    private int bufsize;

    public ValuesCheckerRunnable(long start, long end, int bufsize, int threadNum, String mapperSpec, DataMapper<?> dataMapper, ConcurrentLinkedQueue<Integer> readyQueue, Condition goTime, Lock lock, List<Object> expected) {
        this.start = start;
        this.end = end;
        this.bufsize = bufsize;
        this.threadNum = threadNum;
        this.readyQueue = readyQueue;
        this.expected = expected;
        this.goTime = goTime;
        this.lock = lock;
        this.mapper = dataMapper != null ? dataMapper : VirtData.getOptionalMapper(mapperSpec).orElseThrow(() -> new RuntimeException("unable to resolve mapper for " + mapperSpec));
    }

    @Override
    public void run() {
        Object[] output = new Object[this.bufsize];
        for (long rangeStart = this.start; rangeStart < this.end; rangeStart += (long)this.bufsize) {
            int i;
            String rangeInfo = "t:" + this.threadNum + " [" + rangeStart + ".." + (rangeStart + (long)this.bufsize) + ")";
            this.synchronizeFor("generation start " + rangeInfo);
            for (i = 0; i < output.length; ++i) {
                output[i] = this.mapper.get((long)i + rangeStart);
            }
            if (this.threadNum == 0) {
                logger.trace("Thread " + this.threadNum + " putting values into comparable array before acking");
                this.expected.clear();
                this.expected.addAll(Arrays.asList(output));
                if (System.getProperties().containsKey("PRINTVALUES")) {
                    for (i = 0; i < output.length; ++i) {
                        System.out.println(this.start + (long)i + "->" + output[i]);
                    }
                }
            }
            this.synchronizeFor("generation complete " + rangeInfo);
            this.synchronizeFor("verification " + rangeInfo);
            for (int bufidx = 0; bufidx < this.expected.size(); ++bufidx) {
                if (this.expected.get(bufidx).equals(output[bufidx])) continue;
                String errmsg = "Value differs: iteration: " + ((long)bufidx + rangeStart) + " expected:'" + this.expected.get(bufidx) + "' actual:'" + output[bufidx] + "'";
                throw new RuntimeException(errmsg);
            }
            this.synchronizeFor("verification complete" + rangeInfo);
        }
    }

    private void synchronizeFor(String forWhat) {
        try {
            this.lock.lock();
            this.readyQueue.add(this.threadNum);
            logger.trace("awaiting signal for " + forWhat);
            this.goTime.await();
        }
        catch (Throwable e) {
            System.out.println("error while synchronizing: " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

