/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NotFiniteNumberException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.Pair;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.DiscreteProbabilityCollectionSampler;

public class EnumeratedDistribution<T>
implements Serializable {
    private static final long serialVersionUID = 20160319L;
    private final List<T> singletons;
    private final double[] probabilities;
    private final double[] cumulativeProbabilities;

    public EnumeratedDistribution(List<Pair<T, Double>> pmf) throws NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this.singletons = new ArrayList<T>(pmf.size());
        double[] probs = new double[pmf.size()];
        for (int i = 0; i < pmf.size(); ++i) {
            Pair<T, Double> sample = pmf.get(i);
            this.singletons.add(sample.getKey());
            double p = sample.getValue();
            if (p < 0.0) {
                throw new NotPositiveException(sample.getValue());
            }
            if (Double.isInfinite(p)) {
                throw new NotFiniteNumberException(p, new Object[0]);
            }
            if (Double.isNaN(p)) {
                throw new NotANumberException();
            }
            probs[i] = p;
        }
        this.probabilities = MathArrays.normalizeArray(probs, 1.0);
        this.cumulativeProbabilities = new double[this.probabilities.length];
        double sum = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.cumulativeProbabilities[i] = sum += this.probabilities[i];
        }
    }

    double probability(T x) {
        double probability = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            if ((x != null || this.singletons.get(i) != null) && (x == null || !x.equals(this.singletons.get(i)))) continue;
            probability += this.probabilities[i];
        }
        return probability;
    }

    public List<Pair<T, Double>> getPmf() {
        ArrayList<Pair<T, Double>> samples = new ArrayList<Pair<T, Double>>(this.probabilities.length);
        for (int i = 0; i < this.probabilities.length; ++i) {
            samples.add(new Pair<T, Double>(this.singletons.get(i), this.probabilities[i]));
        }
        return samples;
    }

    public Sampler createSampler(UniformRandomProvider rng) {
        return new Sampler(rng);
    }

    public class Sampler {
        private final DiscreteProbabilityCollectionSampler<T> sampler;

        Sampler(UniformRandomProvider rng) {
            this.sampler = new DiscreteProbabilityCollectionSampler(rng, EnumeratedDistribution.this.singletons, EnumeratedDistribution.this.probabilities);
        }

        public T sample() {
            return this.sampler.sample();
        }

        public Object[] sample(int sampleSize) throws NotStrictlyPositiveException {
            if (sampleSize <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, sampleSize);
            }
            Object[] out = new Object[sampleSize];
            for (int i = 0; i < sampleSize; ++i) {
                out[i] = this.sample();
            }
            return out;
        }

        public T[] sample(int sampleSize, T[] array) throws NotStrictlyPositiveException {
            Object[] out;
            if (sampleSize <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, sampleSize);
            }
            if (array == null) {
                throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
            }
            if (array.length < sampleSize) {
                Object[] unchecked = (Object[])Array.newInstance(array.getClass().getComponentType(), sampleSize);
                out = unchecked;
            } else {
                out = array;
            }
            for (int i = 0; i < sampleSize; ++i) {
                out[i] = this.sample();
            }
            return out;
        }
    }
}

