/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import java.math.BigInteger;
import java.text.MessageFormat;

public final class ArithmeticUtils {
    private ArithmeticUtils() {
    }

    public static int addAndCheck(int x, int y) {
        long s = (long)x + (long)y;
        if (s < Integer.MIN_VALUE || s > Integer.MAX_VALUE) {
            throw new NumbersArithmeticException("overflow in addition: {0} + {1}", x, y);
        }
        return (int)s;
    }

    public static long addAndCheck(long a, long b) {
        return ArithmeticUtils.addAndCheck(a, b, "overflow in addition: {0} + {1}");
    }

    public static int gcd(int p, int q) {
        int a = p;
        int b = q;
        if (a == 0 || b == 0) {
            if (a == Integer.MIN_VALUE || b == Integer.MIN_VALUE) {
                throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
            }
            return Math.abs(a + b);
        }
        long al = a;
        long bl = b;
        boolean useLong = false;
        if (a < 0) {
            if (Integer.MIN_VALUE == a) {
                useLong = true;
            } else {
                a = -a;
            }
            al = -al;
        }
        if (b < 0) {
            if (Integer.MIN_VALUE == b) {
                useLong = true;
            } else {
                b = -b;
            }
            bl = -bl;
        }
        if (useLong) {
            if (al == bl) {
                throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
            }
            long blbu = bl;
            bl = al;
            if ((al = blbu % al) == 0L) {
                if (bl > Integer.MAX_VALUE) {
                    throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
                }
                return (int)bl;
            }
            blbu = bl;
            b = (int)al;
            a = (int)(blbu % al);
        }
        return ArithmeticUtils.gcdPositive(a, b);
    }

    private static int gcdPositive(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        int shift = Math.min(aTwos, bTwos);
        while (a != b) {
            int delta = a - b;
            b = Math.min(a, b);
            a = Math.abs(delta);
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << shift;
    }

    public static long gcd(long p, long q) {
        long t;
        int k;
        long u = p;
        long v = q;
        if (u == 0L || v == 0L) {
            if (u == Long.MIN_VALUE || v == Long.MIN_VALUE) {
                throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^63", p, q);
            }
            return Math.abs(u) + Math.abs(v);
        }
        if (u > 0L) {
            u = -u;
        }
        if (v > 0L) {
            v = -v;
        }
        for (k = 0; (u & 1L) == 0L && (v & 1L) == 0L && k < 63; ++k) {
            u /= 2L;
            v /= 2L;
        }
        if (k == 63) {
            throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^63", p, q);
        }
        long l = t = (u & 1L) == 1L ? v : -(u / 2L);
        while (true) {
            if ((t & 1L) == 0L) {
                t /= 2L;
                continue;
            }
            if (t > 0L) {
                u = -t;
            } else {
                v = t;
            }
            if ((t = (v - u) / 2L) == 0L) break;
        }
        return -u * (1L << k);
    }

    public static int lcm(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        int lcm = Math.abs(ArithmeticUtils.mulAndCheck(a / ArithmeticUtils.gcd(a, b), b));
        if (lcm == Integer.MIN_VALUE) {
            throw new NumbersArithmeticException("overflow: lcm({0}, {1}) is 2^31", a, b);
        }
        return lcm;
    }

    public static long lcm(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long lcm = Math.abs(ArithmeticUtils.mulAndCheck(a / ArithmeticUtils.gcd(a, b), b));
        if (lcm == Long.MIN_VALUE) {
            throw new NumbersArithmeticException("overflow: lcm({0}, {1}) is 2^63", a, b);
        }
        return lcm;
    }

    public static int mulAndCheck(int x, int y) {
        long m = (long)x * (long)y;
        if (m < Integer.MIN_VALUE || m > Integer.MAX_VALUE) {
            throw new NumbersArithmeticException();
        }
        return (int)m;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long a, long b) {
        if (a > b) {
            return ArithmeticUtils.mulAndCheck(b, a);
        }
        if (a < 0L) {
            if (b < 0L) {
                if (a < Long.MAX_VALUE / b) throw new NumbersArithmeticException();
                return a * b;
            }
            if (b <= 0L) return 0L;
            if (Long.MIN_VALUE / b > a) throw new NumbersArithmeticException();
            return a * b;
        }
        if (a <= 0L) return 0L;
        if (a > Long.MAX_VALUE / b) throw new NumbersArithmeticException();
        return a * b;
    }

    public static int subAndCheck(int x, int y) {
        long s = (long)x - (long)y;
        if (s < Integer.MIN_VALUE || s > Integer.MAX_VALUE) {
            throw new NumbersArithmeticException("overflow in subtraction: {0} - {1}", x, y);
        }
        return (int)s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long subAndCheck(long a, long b) {
        if (b != Long.MIN_VALUE) return ArithmeticUtils.addAndCheck(a, -b, "overflow in subtraction: {0} + {1}");
        if (a >= 0L) throw new NumbersArithmeticException("overflow in subtraction: {0} + {1}", a, -b);
        return a - b;
    }

    public static int pow(int k, int e) {
        if (e < 0) {
            throw new IllegalArgumentException("negative exponent ({" + e + "})");
        }
        int exp = e;
        int result = 1;
        int k2p = k;
        while (true) {
            if ((exp & 1) != 0) {
                result = ArithmeticUtils.mulAndCheck(result, k2p);
            }
            if ((exp >>= 1) == 0) break;
            k2p = ArithmeticUtils.mulAndCheck(k2p, k2p);
        }
        return result;
    }

    public static long pow(long k, int e) {
        if (e < 0) {
            throw new IllegalArgumentException("negative exponent ({" + e + "})");
        }
        int exp = e;
        long result = 1L;
        long k2p = k;
        while (true) {
            if ((exp & 1) != 0) {
                result = ArithmeticUtils.mulAndCheck(result, k2p);
            }
            if ((exp >>= 1) == 0) break;
            k2p = ArithmeticUtils.mulAndCheck(k2p, k2p);
        }
        return result;
    }

    public static BigInteger pow(BigInteger k, int e) {
        if (e < 0) {
            throw new IllegalArgumentException("negative exponent ({" + e + "})");
        }
        return k.pow(e);
    }

    public static BigInteger pow(BigInteger k, long e) {
        if (e < 0L) {
            throw new IllegalArgumentException("negative exponent ({" + e + "})");
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k;
        while (e != 0L) {
            if ((e & 1L) != 0L) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e >>= 1;
        }
        return result;
    }

    public static BigInteger pow(BigInteger k, BigInteger e) {
        if (e.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("negative exponent ({" + e + "})");
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k;
        while (!BigInteger.ZERO.equals(e)) {
            if (e.testBit(0)) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e = e.shiftRight(1);
        }
        return result;
    }

    private static long addAndCheck(long a, long b, String message) {
        long result = a + b;
        if ((a ^ b) >= 0L && (a ^ result) < 0L) {
            throw new NumbersArithmeticException(message, a, b);
        }
        return result;
    }

    public static boolean isPowerOfTwo(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static int remainderUnsigned(int dividend, int divisor) {
        if (divisor >= 0) {
            int q;
            if (dividend >= 0) {
                return dividend % divisor;
            }
            if ((dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0 || dividend >= divisor) {
                dividend -= divisor;
            }
            return dividend;
        }
        return dividend >= 0 || dividend < divisor ? dividend : dividend - divisor;
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q;
            if (dividend >= 0L) {
                return dividend % divisor;
            }
            if ((dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0L || dividend >= divisor) {
                dividend -= divisor;
            }
            return dividend;
        }
        return dividend >= 0L || dividend < divisor ? dividend : dividend - divisor;
    }

    public static int divideUnsigned(int dividend, int divisor) {
        if (divisor >= 0) {
            int q;
            if (dividend >= 0) {
                return dividend / divisor;
            }
            if ((long)(dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0L || dividend >= divisor) {
                ++q;
            }
            return q;
        }
        return dividend >= 0 || dividend < divisor ? 0 : 1;
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q;
            if (dividend >= 0L) {
                return dividend / divisor;
            }
            if ((dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0L || dividend >= divisor) {
                ++q;
            }
            return q;
        }
        return dividend >= 0L || dividend < divisor ? 0L : 1L;
    }

    private static class NumbersArithmeticException
    extends ArithmeticException {
        private static final long serialVersionUID = 20180130L;
        private final Object[] formatArguments;

        NumbersArithmeticException() {
            this("arithmetic exception", new Object[0]);
        }

        NumbersArithmeticException(String message, Object ... args) {
            super(message);
            this.formatArguments = args;
        }

        @Override
        public String getMessage() {
            return MessageFormat.format(super.getMessage(), this.formatArguments);
        }
    }
}

