/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SubsetSamplerUtils;

public class PermutationSampler {
    private final int[] domain;
    private final int size;
    private final UniformRandomProvider rng;

    public PermutationSampler(UniformRandomProvider rng, int n, int k) {
        SubsetSamplerUtils.checkSubset(n, k);
        this.domain = PermutationSampler.natural(n);
        this.size = k;
        this.rng = rng;
    }

    public int[] sample() {
        return SubsetSamplerUtils.partialSample(this.domain, this.size, this.rng, true);
    }

    public static void shuffle(UniformRandomProvider rng, int[] list) {
        PermutationSampler.shuffle(rng, list, list.length - 1, true);
    }

    public static void shuffle(UniformRandomProvider rng, int[] list, int start, boolean towardHead) {
        if (towardHead) {
            for (int i = start; i > 0; --i) {
                SubsetSamplerUtils.swap(list, i, rng.nextInt(i + 1));
            }
        } else {
            for (int i = list.length - 1; i > start; --i) {
                SubsetSamplerUtils.swap(list, i, rng.nextInt(i - start + 1) + start);
            }
        }
    }

    public static int[] natural(int n) {
        int[] a = new int[n];
        for (int i = 0; i < n; ++i) {
            a[i] = i;
        }
        return a;
    }
}

