/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class AhrensDieterMarsagliaTsangGammaSampler
extends SamplerBase
implements ContinuousSampler {
    private final ContinuousSampler delegate;

    public AhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
        super(null);
        this.delegate = theta < 1.0 ? new SmallThetaAhrensDieterMarsagliaTsangGammaSampler(rng, alpha, theta) : new LargeThetaAhrensDieterMarsagliaTsangGammaSampler(rng, alpha, theta);
    }

    @Override
    public double sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private static class SmallThetaAhrensDieterMarsagliaTsangGammaSampler
    extends BaseAhrensDieterMarsagliaTsangGammaSampler {
        private final double oneOverTheta;
        private final double bGSOptim;

        SmallThetaAhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
            super(rng, alpha, theta);
            this.oneOverTheta = 1.0 / theta;
            this.bGSOptim = 1.0 + theta / Math.E;
        }

        @Override
        public double sample() {
            double x;
            while (true) {
                double u2;
                double u;
                double p;
                if ((p = this.bGSOptim * (u = this.rng.nextDouble())) <= 1.0) {
                    x = Math.pow(p, this.oneOverTheta);
                    u2 = this.rng.nextDouble();
                    if (u2 > Math.exp(-x)) continue;
                    return this.alpha * x;
                }
                x = -Math.log((this.bGSOptim - p) * this.oneOverTheta);
                u2 = this.rng.nextDouble();
                if (!(u2 > Math.pow(x, this.theta - 1.0))) break;
            }
            return this.alpha * x;
        }
    }

    private static class LargeThetaAhrensDieterMarsagliaTsangGammaSampler
    extends BaseAhrensDieterMarsagliaTsangGammaSampler {
        private static final double ONE_THIRD = 0.3333333333333333;
        private final double dOptim;
        private final double cOptim;
        private final NormalizedGaussianSampler gaussian;

        LargeThetaAhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
            super(rng, alpha, theta);
            this.gaussian = new ZigguratNormalizedGaussianSampler(rng);
            this.dOptim = theta - 0.3333333333333333;
            this.cOptim = 0.3333333333333333 / Math.sqrt(this.dOptim);
        }

        @Override
        public double sample() {
            double v;
            while (true) {
                double x;
                double oPcTx;
                if ((v = (oPcTx = 1.0 + this.cOptim * (x = this.gaussian.sample())) * oPcTx * oPcTx) <= 0.0) {
                    continue;
                }
                double x2 = x * x;
                double u = this.rng.nextDouble();
                if (u < 1.0 - 0.0331 * x2 * x2) {
                    return this.alpha * this.dOptim * v;
                }
                if (Math.log(u) < 0.5 * x2 + this.dOptim * (1.0 - v + Math.log(v))) break;
            }
            return this.alpha * this.dOptim * v;
        }
    }

    private static abstract class BaseAhrensDieterMarsagliaTsangGammaSampler
    implements ContinuousSampler {
        protected final UniformRandomProvider rng;
        protected final double theta;
        protected final double alpha;

        BaseAhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
            if (alpha <= 0.0) {
                throw new IllegalArgumentException("alpha is not strictly positive: " + alpha);
            }
            if (theta <= 0.0) {
                throw new IllegalArgumentException("theta is not strictly positive: " + theta);
            }
            this.rng = rng;
            this.alpha = alpha;
            this.theta = theta;
        }

        public String toString() {
            return "Ahrens-Dieter-Marsaglia-Tsang Gamma deviate [" + this.rng.toString() + "]";
        }
    }
}

