/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class DiscreteUniformSampler
extends SamplerBase
implements DiscreteSampler {
    private final DiscreteSampler delegate;

    public DiscreteUniformSampler(UniformRandomProvider rng, int lower, int upper) {
        super(null);
        if (lower > upper) {
            throw new IllegalArgumentException(lower + " > " + upper);
        }
        int range = upper - lower + 1;
        this.delegate = range <= 0 ? new LargeRangeDiscreteUniformSampler(rng, lower, upper) : new SmallRangeDiscreteUniformSampler(rng, lower, range);
    }

    @Override
    public int sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private static class LargeRangeDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int upper;

        LargeRangeDiscreteUniformSampler(UniformRandomProvider rng, int lower, int upper) {
            super(rng, lower);
            this.upper = upper;
        }

        @Override
        public int sample() {
            int r;
            while ((r = this.rng.nextInt()) < this.lower || r > this.upper) {
            }
            return r;
        }
    }

    private static class SmallRangeDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int range;

        SmallRangeDiscreteUniformSampler(UniformRandomProvider rng, int lower, int range) {
            super(rng, lower);
            this.range = range;
        }

        @Override
        public int sample() {
            return this.lower + this.rng.nextInt(this.range);
        }
    }

    private static abstract class AbstractDiscreteUniformSampler
    implements DiscreteSampler {
        protected final UniformRandomProvider rng;
        protected final int lower;

        AbstractDiscreteUniformSampler(UniformRandomProvider rng, int lower) {
            this.rng = rng;
            this.lower = lower;
        }

        public String toString() {
            return "Uniform deviate [" + this.rng.toString() + "]";
        }
    }
}

