/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.LogBeta;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class FDistribution
extends AbstractContinuousDistribution {
    private final double numeratorDegreesOfFreedom;
    private final double denominatorDegreesOfFreedom;

    public FDistribution(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) {
        if (numeratorDegreesOfFreedom <= 0.0) {
            throw new DistributionException("Number {0} is negative", numeratorDegreesOfFreedom);
        }
        if (denominatorDegreesOfFreedom <= 0.0) {
            throw new DistributionException("Number {0} is negative", denominatorDegreesOfFreedom);
        }
        this.numeratorDegreesOfFreedom = numeratorDegreesOfFreedom;
        this.denominatorDegreesOfFreedom = denominatorDegreesOfFreedom;
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        double nhalf = this.numeratorDegreesOfFreedom / 2.0;
        double mhalf = this.denominatorDegreesOfFreedom / 2.0;
        double logx = Math.log(x);
        double logn = Math.log(this.numeratorDegreesOfFreedom);
        double logm = Math.log(this.denominatorDegreesOfFreedom);
        double lognxm = Math.log(this.numeratorDegreesOfFreedom * x + this.denominatorDegreesOfFreedom);
        return nhalf * logn + nhalf * logx - logx + mhalf * logm - nhalf * lognxm - mhalf * lognxm - LogBeta.value(nhalf, mhalf);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret;
        if (x <= 0.0) {
            ret = 0.0;
        } else {
            double n = this.numeratorDegreesOfFreedom;
            double m = this.denominatorDegreesOfFreedom;
            ret = RegularizedBeta.value(n * x / (m + n * x), 0.5 * n, 0.5 * m);
        }
        return ret;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    @Override
    public double getMean() {
        double denominatorDF = this.getDenominatorDegreesOfFreedom();
        if (denominatorDF > 2.0) {
            return denominatorDF / (denominatorDF - 2.0);
        }
        return Double.NaN;
    }

    @Override
    public double getVariance() {
        double denominatorDF = this.getDenominatorDegreesOfFreedom();
        if (denominatorDF > 4.0) {
            double numeratorDF = this.getNumeratorDegreesOfFreedom();
            double denomDFMinusTwo = denominatorDF - 2.0;
            return 2.0 * (denominatorDF * denominatorDF) * (numeratorDF + denominatorDF - 2.0) / (numeratorDF * (denomDFMinusTwo * denomDFMinusTwo) * (denominatorDF - 4.0));
        }
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

