/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.SaddlePointExpansion;

public class HypergeometricDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfSuccesses;
    private final int populationSize;
    private final int sampleSize;

    public HypergeometricDistribution(int populationSize, int numberOfSuccesses, int sampleSize) {
        if (populationSize <= 0) {
            throw new DistributionException("Number {0} is negative", populationSize);
        }
        if (numberOfSuccesses < 0) {
            throw new DistributionException("Number {0} is negative", numberOfSuccesses);
        }
        if (sampleSize < 0) {
            throw new DistributionException("Number {0} is negative", sampleSize);
        }
        if (numberOfSuccesses > populationSize) {
            throw new DistributionException("{0} > {1}", numberOfSuccesses, populationSize);
        }
        if (sampleSize > populationSize) {
            throw new DistributionException("{0} > {1}", sampleSize, populationSize);
        }
        this.numberOfSuccesses = numberOfSuccesses;
        this.populationSize = populationSize;
        this.sampleSize = sampleSize;
    }

    @Override
    public double cumulativeProbability(int x) {
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double ret = x < domain[0] ? 0.0 : (x >= domain[1] ? 1.0 : this.innerCumulativeProbability(domain[0], x, 1));
        return ret;
    }

    private int[] getDomain(int n, int m, int k) {
        return new int[]{this.getLowerDomain(n, m, k), this.getUpperDomain(m, k)};
    }

    private int getLowerDomain(int n, int m, int k) {
        return Math.max(0, m - (n - k));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int m, int k) {
        return Math.min(k, m);
    }

    @Override
    public double probability(int x) {
        double logProbability = this.logProbability(x);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(logProbability);
    }

    @Override
    public double logProbability(int x) {
        double ret;
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        if (x < domain[0] || x > domain[1]) {
            ret = Double.NEGATIVE_INFINITY;
        } else {
            double p = (double)this.sampleSize / (double)this.populationSize;
            double q = (double)(this.populationSize - this.sampleSize) / (double)this.populationSize;
            double p1 = SaddlePointExpansion.logBinomialProbability(x, this.numberOfSuccesses, p, q);
            double p2 = SaddlePointExpansion.logBinomialProbability(this.sampleSize - x, this.populationSize - this.numberOfSuccesses, p, q);
            double p3 = SaddlePointExpansion.logBinomialProbability(this.sampleSize, this.populationSize, p, q);
            ret = p1 + p2 - p3;
        }
        return ret;
    }

    public double upperCumulativeProbability(int x) {
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double ret = x <= domain[0] ? 1.0 : (x > domain[1] ? 0.0 : this.innerCumulativeProbability(domain[1], x, -1));
        return ret;
    }

    private double innerCumulativeProbability(int x0, int x1, int dx) {
        double ret = this.probability(x0);
        while (x0 != x1) {
            ret += this.probability(x0 += dx);
        }
        return ret;
    }

    @Override
    public double getMean() {
        return (double)this.getSampleSize() * ((double)this.getNumberOfSuccesses() / (double)this.getPopulationSize());
    }

    @Override
    public double getVariance() {
        double N = this.getPopulationSize();
        double m = this.getNumberOfSuccesses();
        double n = this.getSampleSize();
        return n * m * (N - n) * (N - m) / (N * N * (N - 1.0));
    }

    @Override
    public int getSupportLowerBound() {
        return Math.max(0, this.getSampleSize() + this.getNumberOfSuccesses() - this.getPopulationSize());
    }

    @Override
    public int getSupportUpperBound() {
        return Math.min(this.getNumberOfSuccesses(), this.getSampleSize());
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

