/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.ErfDifference;
import org.apache.commons.numbers.gamma.Erfc;
import org.apache.commons.numbers.gamma.InverseErf;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.GaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class NormalDistribution
extends AbstractContinuousDistribution {
    private static final double SQRT2 = Math.sqrt(2.0);
    private final double mean;
    private final double standardDeviation;
    private final double logStandardDeviationPlusHalfLog2Pi;

    public NormalDistribution(double mean, double sd) {
        if (sd <= 0.0) {
            throw new DistributionException("Number {0} is negative", sd);
        }
        this.mean = mean;
        this.standardDeviation = sd;
        this.logStandardDeviationPlusHalfLog2Pi = Math.log(sd) + 0.5 * Math.log(Math.PI * 2);
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        double x0 = x - this.mean;
        double x1 = x0 / this.standardDeviation;
        return -0.5 * x1 * x1 - this.logStandardDeviationPlusHalfLog2Pi;
    }

    @Override
    public double cumulativeProbability(double x) {
        double dev = x - this.mean;
        if (Math.abs(dev) > 40.0 * this.standardDeviation) {
            return dev < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 * Erfc.value(-dev / (this.standardDeviation * SQRT2));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        return this.mean + this.standardDeviation * SQRT2 * InverseErf.value(2.0 * p - 1.0);
    }

    @Override
    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("{0} > {1}", x0, x1);
        }
        double denom = this.standardDeviation * SQRT2;
        double v0 = (x0 - this.mean) / denom;
        double v1 = (x1 - this.mean) / denom;
        return 0.5 * ErfDifference.value(v0, v1);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        double s = this.getStandardDeviation();
        return s * s;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new GaussianSampler(new ZigguratNormalizedGaussianSampler(rng), NormalDistribution.this.mean, NormalDistribution.this.standardDeviation);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

