/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;
import org.apache.commons.numbers.combinatorics.LogBinomialCoefficient;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class PascalDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public PascalDistribution(int r, double p) {
        if (r <= 0) {
            throw new DistributionException("Number {0} is negative", r);
        }
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        this.numberOfSuccesses = r;
        this.probabilityOfSuccess = p;
        this.logProbabilityOfSuccess = Math.log(p);
        this.log1mProbabilityOfSuccess = Math.log1p(-p);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        double ret = x < 0 ? 0.0 : BinomialCoefficientDouble.value(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * Math.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * Math.pow(1.0 - this.probabilityOfSuccess, x);
        return ret;
    }

    @Override
    public double logProbability(int x) {
        double ret = x < 0 ? Double.NEGATIVE_INFINITY : LogBinomialCoefficient.value(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) + this.logProbabilityOfSuccess * (double)this.numberOfSuccesses + this.log1mProbabilityOfSuccess * (double)x;
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        double ret = x < 0 ? 0.0 : RegularizedBeta.value(this.probabilityOfSuccess, this.numberOfSuccesses, (double)x + 1.0);
        return ret;
    }

    @Override
    public double getMean() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        return r * (1.0 - p) / p;
    }

    @Override
    public double getVariance() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        return r * (1.0 - p) / (p * p);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

