/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Cfgmgr32;
import com.sun.jna.platform.win32.Cfgmgr32Util;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.driver.windows.wmi.Win32DiskDrive;
import oshi.driver.windows.wmi.Win32PnPEntity;
import oshi.driver.windows.wmi.Win32USBController;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsUsbDevice
extends AbstractUsbDevice {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsUsbDevice.class);
    private static final Pattern VENDOR_PRODUCT_ID = Pattern.compile(".*(?:VID|VEN)_(\\p{XDigit}{4})&(?:PID|DEV)_(\\p{XDigit}{4}).*");

    public WindowsUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, String uniqueDeviceId, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, uniqueDeviceId, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = WindowsUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[0]);
    }

    private static UsbDevice[] getUsbDevices() {
        HashMap<String, List<String>> deviceTreeMap = new HashMap<String, List<String>>();
        HashSet<String> devicesSeen = new HashSet<String>();
        ArrayList<WindowsUsbDevice> controllerDevices = new ArrayList<WindowsUsbDevice>();
        List<String> controllerDeviceIdList = WindowsUsbDevice.getControllerDeviceIdList();
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice.putChildrenInDeviceTree(controllerDeviceId, 0, deviceTreeMap, devicesSeen);
        }
        Map<String, WindowsUsbDevice> usbDeviceCache = WindowsUsbDevice.populateDeviceCache(devicesSeen);
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(controllerDeviceId, "0000", "0000", deviceTreeMap, usbDeviceCache);
            if (deviceAndChildren == null) continue;
            controllerDevices.add(deviceAndChildren);
        }
        return controllerDevices.toArray(new WindowsUsbDevice[0]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(new WindowsUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), device.getUniqueDeviceId(), new UsbDevice[0]));
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static Map<String, WindowsUsbDevice> populateDeviceCache(Set<String> devicesToAdd) {
        HashMap<String, WindowsUsbDevice> usbDeviceCache = new HashMap<String, WindowsUsbDevice>();
        if (!devicesToAdd.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String deviceID : devicesToAdd) {
                if (first) {
                    sb.append(" WHERE (PnPDeviceID=\"");
                    first = false;
                } else {
                    sb.append(" OR (PnPDeviceID=\"");
                }
                sb.append(deviceID).append("\")");
            }
            String whereClause = sb.toString();
            WbemcliUtil.WmiResult<Win32PnPEntity.PnPEntityProperty> pnpEntity = Win32PnPEntity.queryDeviceId(whereClause);
            for (int i = 0; i < pnpEntity.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.PNPDEVICEID, i);
                String name = WmiUtil.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.NAME, i);
                String vendor = WmiUtil.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.MANUFACTURER, i);
                WindowsUsbDevice device = new WindowsUsbDevice(name, vendor, null, null, "", pnpDeviceID, new WindowsUsbDevice[0]);
                usbDeviceCache.put(pnpDeviceID, device);
                LOG.debug("Adding {} to USB device cache.", (Object)pnpDeviceID);
            }
            WbemcliUtil.WmiResult<Win32DiskDrive.DeviceIdProperty> serialNumbers = Win32DiskDrive.queryDiskDriveId(whereClause);
            for (int i = 0; i < serialNumbers.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(serialNumbers, Win32DiskDrive.DeviceIdProperty.PNPDEVICEID, i);
                if (!usbDeviceCache.containsKey(pnpDeviceID)) continue;
                WindowsUsbDevice device = (WindowsUsbDevice)usbDeviceCache.get(pnpDeviceID);
                device.serialNumber = ParseUtil.hexStringToString(WmiUtil.getString(serialNumbers, Win32DiskDrive.DeviceIdProperty.SERIALNUMBER, i));
            }
        }
        return usbDeviceCache;
    }

    private static void putChildrenInDeviceTree(String deviceId, int deviceInstance, Map<String, List<String>> deviceTreeMap, Set<String> devicesSeen) {
        IntByReference child;
        devicesSeen.add(deviceId);
        int devInst = deviceInstance;
        if (devInst == 0) {
            IntByReference pdnDevInst = new IntByReference();
            Cfgmgr32.INSTANCE.CM_Locate_DevNode(pdnDevInst, deviceId, 0);
            devInst = pdnDevInst.getValue();
        }
        if (0 == Cfgmgr32.INSTANCE.CM_Get_Child(child = new IntByReference(), devInst, 0)) {
            ArrayList<String> childList = new ArrayList<String>();
            String childId = Cfgmgr32Util.CM_Get_Device_ID(child.getValue());
            childList.add(childId);
            deviceTreeMap.put(deviceId, childList);
            WindowsUsbDevice.putChildrenInDeviceTree(childId, child.getValue(), deviceTreeMap, devicesSeen);
            IntByReference sibling = new IntByReference();
            while (0 == Cfgmgr32.INSTANCE.CM_Get_Sibling(sibling, child.getValue(), 0)) {
                String siblingId = Cfgmgr32Util.CM_Get_Device_ID(sibling.getValue());
                deviceTreeMap.get(deviceId).add(siblingId);
                WindowsUsbDevice.putChildrenInDeviceTree(siblingId, sibling.getValue(), deviceTreeMap, devicesSeen);
                child = sibling;
            }
        }
    }

    private static WindowsUsbDevice getDeviceAndChildren(String hubDeviceId, String vid, String pid, Map<String, List<String>> deviceTreeMap, Map<String, WindowsUsbDevice> usbDeviceCache) {
        String vendorId = vid;
        String productId = pid;
        Matcher m = VENDOR_PRODUCT_ID.matcher(hubDeviceId);
        if (m.matches()) {
            vendorId = m.group(1).toLowerCase();
            productId = m.group(2).toLowerCase();
        }
        List pnpDeviceIds = deviceTreeMap.getOrDefault(hubDeviceId, new ArrayList());
        ArrayList<WindowsUsbDevice> usbDevices = new ArrayList<WindowsUsbDevice>();
        for (String pnpDeviceId : pnpDeviceIds) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(pnpDeviceId, vendorId, productId, deviceTreeMap, usbDeviceCache);
            if (deviceAndChildren == null) continue;
            usbDevices.add(deviceAndChildren);
        }
        Collections.sort(usbDevices);
        if (usbDeviceCache.containsKey(hubDeviceId)) {
            WindowsUsbDevice device = usbDeviceCache.get(hubDeviceId);
            if (device.name.isEmpty()) {
                device.name = vendorId + ":" + productId;
            }
            device.vendorId = vendorId;
            device.productId = productId;
            device.connectedDevices = usbDevices.toArray(new WindowsUsbDevice[0]);
            return device;
        }
        return null;
    }

    private static List<String> getControllerDeviceIdList() {
        ArrayList<String> controllerDeviceIdsList = new ArrayList<String>();
        WbemcliUtil.WmiResult<Win32USBController.USBControllerProperty> usbController = Win32USBController.queryUSBControllers();
        for (int i = 0; i < usbController.getResultCount(); ++i) {
            controllerDeviceIdsList.add(WmiUtil.getString(usbController, Win32USBController.USBControllerProperty.PNPDEVICEID, i));
        }
        return controllerDeviceIdsList;
    }
}

