/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig;

import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.nb.api.config.params.Element;
import io.nosqlbench.nb.api.config.params.NBParams;
import io.nosqlbench.virtdata.core.templates.BindPoint;
import io.nosqlbench.virtdata.core.templates.ParsedTemplate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ParsedStmtOp {
    private final OpTemplate optpl;
    private final ParsedTemplate parsed;

    public ParsedStmtOp(OpTemplate optpl) {
        this.optpl = optpl;
        String transformed = this.getStmt();
        this.parsed = new ParsedTemplate(transformed, optpl.getBindings());
    }

    public ParsedStmtOp orError() {
        if (this.hasError()) {
            throw new RuntimeException("Unable to parse statement: " + this);
        }
        return this;
    }

    public String toString() {
        return this.parsed.toString();
    }

    public boolean hasError() {
        return this.parsed.hasError();
    }

    public Set<String> getMissingBindings() {
        return this.parsed.getMissing();
    }

    public String getPositionalStatement(Function<String, String> tokenMapper) {
        return this.parsed.getPositionalStatement(tokenMapper);
    }

    public String getName() {
        return this.optpl.getName();
    }

    public String getStmt() {
        return (String)this.optpl.getStmt().orElseThrow();
    }

    public Map<String, String> getTags() {
        return this.optpl.getTags();
    }

    public Map<String, String> getBindings() {
        return this.optpl.getBindings();
    }

    public Element getParamReader() {
        return NBParams.one((String)this.getName(), (Object)this.optpl.getParams());
    }

    public List<BindPoint> getBindPoints() {
        return this.parsed.getBindPoints();
    }
}

