/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.yaml;

import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import java.security.InvalidParameterException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class OpData
extends OpTemplate {
    private String desc = "";
    private String name = "";
    private Map<String, Object> op;
    private Map<String, Object> params = Map.of();
    private Map<String, String> bindings = Map.of();
    private Map<String, String> tags = new LinkedHashMap<String, String>();

    public OpData(String desc, String name, Map<String, String> tags, Map<String, String> bindings, Map<String, Object> params, Map<String, Object> op) {
        this.desc = desc;
        this.name = name;
        this.tags = tags;
        this.bindings = bindings;
        this.params = params;
        this.op = op;
    }

    public OpData() {
    }

    public OpData(Map<String, Object> opdata) {
        this.applyFields(opdata);
        if (opdata.size() > 0) {
            throw new RuntimeException("Unconsumed fields in construction of op data from map: " + opdata);
        }
    }

    public OpData applyFields(Map<String, Object> opdata) {
        LinkedHashMap<String, Object> toapply = new LinkedHashMap<String, Object>(opdata);
        Optional.ofNullable(toapply.remove("description")).ifPresent(v -> this.setDesc(v.toString()));
        Optional.ofNullable(toapply.remove("name")).ifPresent(v -> this.setName(v.toString()));
        Optional.ofNullable(toapply.remove("bindings")).ifPresent(this::setBindings);
        Optional.ofNullable(toapply.remove("op")).ifPresent(this::setOp);
        Optional.ofNullable(toapply.remove("params")).ifPresent(this::setParams);
        Optional.ofNullable(toapply.remove("tags")).ifPresent(this::setTags);
        if (toapply.size() > 0) {
            throw new InvalidParameterException("Fields were not applied to OpData:" + toapply);
        }
        return this;
    }

    private void setTags(Object o) {
        if (!(o instanceof Map)) {
            throw new RuntimeException("Invalid type for tags: " + o.getClass().getSimpleName());
        }
        ((Map)o).forEach((k, v) -> this.tags.put(k.toString(), v.toString()));
    }

    private void setParams(Object o) {
        if (!(o instanceof Map)) {
            throw new RuntimeException("Invalid type for params: " + this.op.getClass().getSimpleName());
        }
        this.params = new LinkedHashMap<String, Object>();
        ((Map)o).forEach((k, v) -> this.params.put(k.toString(), v));
    }

    private void setOp(Object o) {
        if (o instanceof CharSequence) {
            this.op = new LinkedHashMap<String, String>(Map.of("stmt", o.toString()));
        } else if (o instanceof Map) {
            this.op = new LinkedHashMap<String, Object>((Map)o);
        } else {
            throw new RuntimeException("Invalid type for op:" + this.op.getClass().getSimpleName());
        }
    }

    private void setBindings(Object bindings) {
        if (bindings instanceof Map) {
            this.bindings = new LinkedHashMap<String, String>();
            ((Map)bindings).forEach((k, v) -> this.bindings.put(k.toString(), v.toString()));
        } else if (bindings != null) {
            throw new RuntimeException("Invalid type for bindings: " + bindings.getClass().getSimpleName());
        }
    }

    private void setName(String name) {
        this.name = name;
        this.tags.put("name", name);
    }

    private void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, String> getBindings() {
        return this.bindings;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Optional<Map<String, Object>> getOp() {
        return Optional.of(this.op);
    }

    public Optional<String> getStmt() {
        return Optional.empty();
    }
}

