/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Timer;
import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.ActivityInstrumentation;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.ParameterMap;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;

public class CoreActivityInstrumentation
implements ActivityInstrumentation {
    private static final String STRICTMETRICNAMES = "strictmetricnames";
    private static final String WAIT_TIME = ".waittime";
    private static final String SERVICE_TIME = ".servicetime";
    private static final String RESPONSE_TIME = ".responsetime";
    private final Activity activity;
    private final ActivityDef def;
    private final ParameterMap params;
    private final String svcTimeSuffix;
    private final boolean strictNaming;

    public CoreActivityInstrumentation(Activity activity) {
        this.activity = activity;
        this.def = activity.getActivityDef();
        this.params = this.def.getParams();
        this.strictNaming = this.params.getOptionalBoolean(STRICTMETRICNAMES).orElse(true);
        this.svcTimeSuffix = this.strictNaming ? SERVICE_TIME : "";
    }

    @Override
    public synchronized Timer getOrCreateInputTimer() {
        String metricName = "read_input";
        return ActivityMetrics.timer((ActivityDef)this.def, (String)metricName);
    }

    @Override
    public synchronized Timer getOrCreateStridesServiceTimer() {
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"strides.servicetime");
    }

    @Override
    public synchronized Timer getStridesResponseTimerOrNull() {
        if (this.activity.getStrideLimiter() == null) {
            return null;
        }
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"strides.responsetime");
    }

    @Override
    public synchronized Timer getOrCreateCyclesServiceTimer() {
        return ActivityMetrics.timer((ActivityDef)this.def, (String)("cycles" + this.svcTimeSuffix));
    }

    @Override
    public synchronized Timer getCyclesResponseTimerOrNull() {
        if (this.activity.getCycleLimiter() == null) {
            return null;
        }
        String metricName = "cycles.responsetime";
        return ActivityMetrics.timer((ActivityDef)this.def, (String)metricName);
    }

    @Override
    public synchronized Timer getOrCreatePhasesServiceTimer() {
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"phases.servicetime");
    }

    @Override
    public synchronized Timer getPhasesResponseTimerOrNull() {
        if (this.activity.getPhaseLimiter() == null) {
            return null;
        }
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"phases.responsetime");
    }

    @Override
    public synchronized Counter getOrCreatePendingOpCounter() {
        String metricName = "pending_ops";
        return ActivityMetrics.counter((ActivityDef)this.def, (String)metricName);
    }

    @Override
    public synchronized Counter getOrCreateOpTrackerBlockedCounter() {
        String metricName = "optracker_blocked";
        return ActivityMetrics.counter((ActivityDef)this.def, (String)metricName);
    }

    @Override
    public synchronized Timer getOrCreateBindTimer() {
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"bind");
    }

    @Override
    public synchronized Timer getOrCreateExecuteTimer() {
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"execute");
    }

    @Override
    public synchronized Timer getOrCreateResultTimer() {
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"result");
    }

    @Override
    public synchronized Timer getOrCreateResultSuccessTimer() {
        return ActivityMetrics.timer((ActivityDef)this.def, (String)"result-success");
    }

    @Override
    public synchronized Histogram getOrCreateTriesHistogram() {
        return ActivityMetrics.histogram((ActivityDef)this.def, (String)"tries");
    }
}

