/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.core;

public interface ProgressMeter {
    public String getProgressName();

    public long getStartedAtMillis();

    public long getProgressMin();

    public long getProgressCurrent();

    public long getProgressMax();

    public long getRecyclesCurrent();

    public long getRecyclesMax();

    default public String getProgressSummary() {
        return "min=" + this.getProgressMin() + " cycle=" + this.getProgressCurrent() + " max=" + this.getProgressMax() + (String)(this.getRecyclesMax() > 0L ? " recycles=" + this.getRecyclesCurrent() + "/" + this.getRecyclesMax() : "");
    }

    default public double getProgressRatio() {
        return (double)(this.getProgressCurrent() - this.getProgressMin()) / (double)(this.getProgressMax() - this.getProgressMin());
    }

    default public double getProgressTotal() {
        return this.getProgressMax() - this.getProgressMin();
    }

    default public double getProgressETAMillis() {
        long then = this.getStartedAtMillis();
        long now = System.currentTimeMillis();
        double elapsed = now - then;
        double completed = this.getProgressCurrent() - this.getProgressMin();
        double rate = completed / elapsed;
        double remaining = this.getProgressMax() - this.getProgressCurrent();
        return remaining / rate;
    }
}

