/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.buffers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Buffer<T extends Comparable> {
    private int position;
    private int limit;
    protected ArrayList<T> data;

    public Buffer(int size) {
        this.data = new ArrayList(size);
        this.limit = size;
    }

    protected void onFull() {
    }

    protected abstract int compare(T var1, T var2);

    public int remaining() {
        return this.limit - this.position;
    }

    public Buffer<T> put(T element) {
        this.data.add(element);
        if (this.data.size() == this.limit) {
            this.onFull();
        }
        return this;
    }

    public List<T> getFlippedData() {
        return this.data;
    }

    public String toString() {
        return "position=" + this.position + ", limit=" + this.limit + ", capacity=" + (Serializable)(this.data != null ? Integer.valueOf(this.data.size()) : "NULLDATA");
    }
}

