/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResult;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultsSegmentReadable;
import java.nio.ByteBuffer;

public class CycleResultSegmentBuffer {
    private ByteBuffer buf;
    private static final int BYTES = 9;
    private final Sink sink;

    public CycleResultSegmentBuffer(Sink sink, int resultCount) {
        this.sink = sink;
        this.buf = ByteBuffer.allocate(resultCount * 9);
    }

    public CycleResultSegmentBuffer(int resultCount) {
        this.sink = null;
        this.buf = ByteBuffer.allocate(resultCount * 9);
    }

    public void append(long cycle, int result) {
        this.buf.putLong(cycle).put((byte)result);
        if (this.sink != null && !this.buf.hasRemaining()) {
            this.sink.handle(this.toReader());
        }
    }

    public void append(CycleResult result) {
        this.buf.putLong(result.getCycle()).put((byte)result.getResult());
        if (this.sink != null && !this.buf.hasRemaining()) {
            this.sink.handle(this.toReader());
        }
    }

    public CycleResultsSegment toReader() {
        this.buf.flip();
        CycleResultsSegmentReadable readable = new CycleResultsSegmentReadable(this.buf);
        this.buf = null;
        return readable;
    }

    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    public static interface Sink {
        public void handle(CycleResultsSegment var1);
    }
}

