/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results_rle;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.CycleResultSegmentsReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results_rle.CycleSpanResults;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.function.Predicate;

public class CycleResultsRLEBufferReadable
implements CycleResultSegmentsReadable {
    public static final int BYTES = 17;
    private final ByteBuffer buf;

    public CycleResultsRLEBufferReadable(ByteBuffer buf) {
        this.buf = buf;
    }

    public CycleResultsRLEBufferReadable(int readSizeInSpans, ByteBuffer src) {
        int bufsize = Math.min(readSizeInSpans *= 17, src.remaining());
        byte[] bbuf = new byte[bufsize];
        src.get(bbuf);
        this.buf = ByteBuffer.wrap(bbuf);
    }

    public Iterator<CycleResultsSegment> iterator(Predicate<ResultReadable> filter) {
        return new ResultSpanIterator(this.buf, filter);
    }

    @Override
    public Iterator<CycleResultsSegment> iterator() {
        return new ResultSpanIterator(this.buf, null);
    }

    private class ResultSpanIterator
    implements Iterator<CycleResultsSegment> {
        private final ByteBuffer iterbuf;
        private final Predicate<ResultReadable> filter;
        private CycleResultsSegment next;

        public ResultSpanIterator(ByteBuffer buf, Predicate<ResultReadable> filter) {
            this.iterbuf = buf;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.iterbuf.remaining() > 0) {
                CycleSpanResults csr = this.read(this.iterbuf);
                if (this.filter != null && !this.filter.test(csr)) continue;
                this.next = csr;
            }
            return this.next != null;
        }

        @Override
        public CycleResultsSegment next() {
            if (this.next == null && !this.hasNext()) {
                throw new RuntimeException("Call to next() but there was no remaining unfiltered data.");
            }
            CycleResultsSegment wasNext = this.next;
            this.next = null;
            return wasNext;
        }

        private CycleSpanResults read(ByteBuffer iterbuf) {
            long min = iterbuf.getLong();
            long nextMin = iterbuf.getLong();
            byte result = iterbuf.get();
            return new CycleSpanResults(min, nextMin, result);
        }

        public String toString() {
            return "ResultSpanIterator (" + this.iterbuf.toString() + ")";
        }
    }
}

