/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results_rle;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResult;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.MutableCycleResult;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import java.util.Iterator;
import java.util.function.Predicate;

public class CycleSpanResults
implements CycleResultsSegment,
ResultReadable {
    private final long min;
    private final long nextMin;
    private final int result;

    public CycleSpanResults(long min, long nextMin, int result) {
        this.min = min;
        this.nextMin = nextMin;
        this.result = result;
    }

    @Override
    public long getCount() {
        return (long)((int)this.nextMin) - this.min;
    }

    @Override
    public long getMinCycle() {
        return this.min;
    }

    @Override
    public int getResult() {
        return this.result;
    }

    public String toString() {
        return "[" + this.min + "," + this.nextMin + ")->" + this.result;
    }

    @Override
    public CycleResultsSegment filter(Predicate<ResultReadable> filter) {
        if (filter.test(this)) {
            return this;
        }
        return CycleResultsSegment.EMPTY;
    }

    @Override
    public Iterator<CycleResult> iterator() {
        return new Iter(this.min, this.nextMin);
    }

    private class Iter
    implements Iterator<CycleResult> {
        private final long nextMin;
        private long next;

        public Iter(long min, long nextMin) {
            this.next = min;
            this.nextMin = nextMin;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.nextMin;
        }

        @Override
        public CycleResult next() {
            return new MutableCycleResult(this.next++, CycleSpanResults.this.result);
        }
    }
}

