/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.filters;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.filters.ResultFilterDispenser;
import io.nosqlbench.engine.api.activityapi.cyclelog.filters.ResultValueFilterType;
import io.nosqlbench.engine.api.activityapi.cyclelog.filters.tristate.ResultFilteringSieve;
import io.nosqlbench.engine.api.activityapi.cyclelog.filters.tristate.TristateFilter;
import io.nosqlbench.engine.api.util.ConfigTuples;
import io.nosqlbench.nb.annotations.Service;
import java.util.function.Predicate;

@Service(value=ResultValueFilterType.class, selector="core")
public class CoreResultValueFilter
implements ResultValueFilterType {
    @Override
    public ResultFilterDispenser getDispenser(String config) {
        return new Dispenser(config);
    }

    private static TristateFilter.Policy getDefaultFromHead(ConfigTuples.Section section) {
        if (section.get(0).startsWith("in")) {
            return TristateFilter.Policy.Discard;
        }
        return TristateFilter.Policy.Keep;
    }

    private static void mapPredicate(ConfigTuples.Section section, ResultFilteringSieve.Builder builder) {
        int max;
        int min;
        String incexc = section.get(0);
        if (incexc.startsWith("in")) {
            incexc = "include";
        } else if (incexc.startsWith("ex")) {
            incexc = "exclude";
        } else {
            throw new RuntimeException("pattern does not start with 'in' or 'ex' for include or exclude:" + incexc);
        }
        if (section.get(1).matches("\\d+-\\d+")) {
            String[] split = section.get(1).split("-");
            min = Integer.valueOf(split[0]);
            max = Integer.valueOf(split[1]);
        } else {
            max = min = Integer.valueOf(section.get(1)).intValue();
        }
        if (min == max) {
            if (incexc.equals("include")) {
                builder.include(min);
            } else {
                builder.exclude(min);
            }
        } else if (incexc.equals("include")) {
            builder.include(min, max);
        } else {
            builder.exclude(min, max);
        }
    }

    public static class Dispenser
    implements ResultFilterDispenser {
        Predicate<ResultReadable> predicate;

        public Dispenser(String config) {
            ConfigTuples conf = new ConfigTuples(config);
            ConfigTuples includesAndExcludes = conf.getAllMatching("in.*", "ex.*");
            ResultFilteringSieve.Builder builder = new ResultFilteringSieve.Builder();
            includesAndExcludes.forEach(s -> CoreResultValueFilter.mapPredicate(s, builder));
            ResultFilteringSieve sieve = builder.build();
            this.predicate = sieve.toDefaultingPredicate(CoreResultValueFilter.getDefaultFromHead(includesAndExcludes.get(0)));
        }

        @Override
        public Predicate<ResultReadable> getResultFilter() {
            return this.predicate;
        }
    }
}

