/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.filters.tristate;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import java.util.function.Predicate;

public interface CycleResultPredicate
extends Predicate<ResultReadable> {

    public static class ResultEquals
    implements CycleResultPredicate {
        private final int value;

        public ResultEquals(int value) {
            this.value = value;
        }

        @Override
        public boolean test(ResultReadable cycleResult) {
            return cycleResult.getResult() == this.value;
        }
    }

    public static class ResultInRange
    implements CycleResultPredicate {
        private final int min;
        private final int max;

        public ResultInRange(int minInclusive, int maxExclusive) {
            this.min = minInclusive;
            this.max = maxExclusive;
        }

        @Override
        public boolean test(ResultReadable cycleResult) {
            return this.min <= cycleResult.getResult() && this.max >= cycleResult.getResult();
        }
    }

    public static class ResultHasAllBits
    implements CycleResultPredicate {
        private int mask;

        public ResultHasAllBits(int mask) {
            this.mask = mask;
        }

        @Override
        public boolean test(ResultReadable cycleResult) {
            return (cycleResult.getResult() & this.mask) == this.mask;
        }
    }

    public static class ResultHasSomeBits
    implements CycleResultPredicate {
        private int mask;

        public ResultHasSomeBits(int mask) {
            this.mask = mask;
        }

        @Override
        public boolean test(ResultReadable cycleResult) {
            return (cycleResult.getResult() & this.mask) > 0;
        }
    }
}

