/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.filters.tristate;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.filters.tristate.ResultMappingArrayFilter;
import io.nosqlbench.engine.api.activityapi.cyclelog.filters.tristate.TristateFilter;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnumReadableMappingFilter<E extends Enum<E>>
implements TristateFilter<ResultReadable> {
    private static final Logger logger = LogManager.getLogger(EnumReadableMappingFilter.class);
    private final E[] enumValues;
    private final ResultMappingArrayFilter arrayFilter = new ResultMappingArrayFilter();

    public EnumReadableMappingFilter(E[] enumValues, TristateFilter.Policy defaultPolicy) {
        this.enumValues = enumValues;
        for (E enumValue : enumValues) {
            this.arrayFilter.addPolicy((ResultReadable)enumValue, defaultPolicy);
        }
    }

    public void addPolicy(String s, TristateFilter.Policy policy) {
        Pattern p = null;
        int matched = 0;
        p = s.matches("\\w+") ? Pattern.compile("^" + s + "$") : Pattern.compile(s);
        for (E enumValue : this.enumValues) {
            if (!((Enum)enumValue).toString().matches(p.pattern())) continue;
            ++matched;
            logger.debug("Setting policy for " + enumValue + " to " + policy);
            int resultCode = ((ResultReadable)enumValue).getResult();
            this.arrayFilter.addPolicy((ResultReadable)enumValue, policy);
        }
        if (matched == 0) {
            StringBuilder sb = new StringBuilder();
            for (E enumValue : this.enumValues) {
                sb.append(((Enum)enumValue).toString()).append(",");
            }
            logger.warn("Unable to match any known type with pattern '" + s + "', available names: " + sb.toString());
        }
    }

    @Override
    public TristateFilter.Policy apply(ResultReadable cycleResult) {
        return this.arrayFilter.apply(cycleResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (E enumValue : this.enumValues) {
            int result = ((ResultReadable)enumValue).getResult();
            sb.append(((Enum)enumValue).toString()).append("->").append(result).append("->").append((Object)this.arrayFilter.getPolicy(result)).append("\n");
        }
        return sb.toString();
    }
}

