/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.filters.tristate;

import java.util.function.Function;
import java.util.function.Predicate;

public interface TristateFilter<T>
extends Function<T, Policy> {
    @Override
    public Policy apply(T var1);

    default public Predicate<T> toDefaultingPredicate(Policy defaultPolicy) {
        return new DefaultingPredicate(this, defaultPolicy);
    }

    default public Predicate<T> toMatchingPredicate(Policy matchingPolicy) {
        return new MatchingPredicate(this, matchingPolicy);
    }

    public static class DefaultingPredicate<T>
    implements Predicate<T> {
        private final TristateFilter<T> filter;
        private final Policy defaultPolicy;

        public DefaultingPredicate(TristateFilter<T> filter, Policy defaultPolicy) {
            this.filter = filter;
            this.defaultPolicy = defaultPolicy;
        }

        @Override
        public boolean test(T t) {
            Policy policyResult = this.filter.apply(t);
            if (policyResult == Policy.Ignore) {
                policyResult = this.defaultPolicy;
            }
            return policyResult == Policy.Keep;
        }
    }

    public static enum Policy {
        Keep,
        Discard,
        Ignore;

    }

    public static class MatchingPredicate<T>
    implements Predicate<T> {
        private final TristateFilter<T> filter;
        private final Policy matchOn;

        public MatchingPredicate(TristateFilter<T> filter, Policy matchOn) {
            this.filter = filter;
            this.matchOn = matchOn;
        }

        @Override
        public boolean test(T t) {
            return this.filter.apply(t) == this.matchOn;
        }
    }
}

