/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results_rle.CycleSpanResults;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog.CycleLogOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CycleLogImporterUtility {
    private static final Pattern linePattern = Pattern.compile("\\[?(?<start>\\d+)(,(?<end>\\d+)\\))?->(?<result>\\d+)");

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("USAGE: CyclesCLI <input-textfile>, <output-cyclelog>");
        }
        String infile = args[0];
        String outfile = args[1];
        try {
            new CycleLogImporterUtility().convert(infile, outfile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void convert(String infile, String outfile) throws Exception {
        CycleLogOutput output = new CycleLogOutput(new File(outfile), 1024);
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = linePattern.matcher(line);
            if (matcher.matches()) {
                long start = Long.valueOf(matcher.group("start"));
                int result = Integer.valueOf(matcher.group("result"));
                String endMatched = matcher.group("end");
                if (endMatched == null) {
                    output.onCycleResult(start, result);
                } else {
                    long end = Long.valueOf(endMatched);
                    output.onCycleResultSegment(new CycleSpanResults(start, end, result));
                }
            } else {
                throw new RuntimeException("Unrecognized line format on import: " + line);
            }
            line = reader.readLine();
        }
        output.close();
    }
}

