/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.outputs.logger;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.inputs.cyclelog.CanFilterResultValue;
import io.nosqlbench.engine.api.activityapi.output.Output;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingOutput
implements Output,
CanFilterResultValue {
    private static final Logger logger = LogManager.getLogger(LoggingOutput.class);
    private final ActivityDef def;
    private final long slot;
    private final ThreadLocal<StringBuilder> sb = ThreadLocal.withInitial(StringBuilder::new);
    private Predicate<ResultReadable> filter;

    public LoggingOutput(ActivityDef def, long slot) {
        this.def = def;
        this.slot = slot;
    }

    @Override
    public boolean onCycleResult(long completedCycle, int result) {
        if (this.filter != null && !this.filter.test(new ResultReadableWrapper(result))) {
            return true;
        }
        this.sb.get().setLength(0);
        this.sb.get().append("activity=").append(this.def.getAlias()).append(",cycle=").append(completedCycle).append(",result=").append((byte)(result & 0x7F));
        logger.info(this.sb.get().toString());
        return true;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void setFilter(Predicate<ResultReadable> filter) {
        this.filter = filter;
    }

    private static class ResultReadableWrapper
    implements ResultReadable {
        private final int result;

        public ResultReadableWrapper(int result) {
            this.result = result;
        }

        @Override
        public int getResult() {
            return this.result;
        }
    }
}

