/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.errorhandling;

import io.nosqlbench.engine.api.activityapi.errorhandling.CycleErrorHandler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CycleErrorHandlers {
    private static final Logger logger = LogManager.getLogger(CycleErrorHandlers.class);

    public static <T extends Throwable, R> CycleErrorHandler<T, R> log(R result) {
        return (cycle, error, errMsg) -> {
            logger.error("in cycle " + cycle + ": " + errMsg, error);
            return result;
        };
    }

    public static <T extends Throwable, R> CycleErrorHandler<T, R> store(List<CycleErrorHandler.Triple> list, R result) {
        return (cycle, error, errMsg) -> {
            list.add(new CycleErrorHandler.Triple<Throwable, Object>(error, cycle, errMsg, result));
            return result;
        };
    }

    public static <T extends Throwable, R> CycleErrorHandler<T, R> rethrow(String prefix) {
        return (cycle, error, errMsg) -> {
            throw new RuntimeException("rethrown(" + prefix + ") in cycle(" + cycle + ") :" + errMsg, error);
        };
    }
}

