/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.errorhandling.modular;

import io.nosqlbench.engine.api.activityapi.errorhandling.ErrorMetrics;
import io.nosqlbench.engine.api.activityapi.errorhandling.modular.ErrorDetail;
import io.nosqlbench.engine.api.activityapi.errorhandling.modular.ErrorHandler;
import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.nb.api.config.params.Element;
import io.nosqlbench.nb.api.config.params.NBParams;
import io.nosqlbench.nb.api.config.standard.NBMapConfigurable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NBErrorHandler {
    private final Supplier<ErrorMetrics> errorMetricsSupplier;
    private final Supplier<String> configSpecSupplier;
    private final Function<Throwable, String> namer;
    private final Map<String, List<ErrorHandler>> handlerCache = new ConcurrentHashMap<String, List<ErrorHandler>>();
    private final List<HandlerMapping> configs = new ArrayList<HandlerMapping>();

    public NBErrorHandler(Supplier<String> configSpecSupplier, Supplier<ErrorMetrics> metricsSupplier) {
        this(configSpecSupplier, metricsSupplier, throwable -> throwable.getClass().getSimpleName());
    }

    public NBErrorHandler(Supplier<String> configSpecSupplier, Supplier<ErrorMetrics> metricsSupplier, Function<Throwable, String> namer) {
        this.errorMetricsSupplier = metricsSupplier;
        this.configSpecSupplier = configSpecSupplier;
        this.namer = namer;
        Arrays.stream(configSpecSupplier.get().split(";")).map(HandlerMapping::new).forEach(this.configs::add);
    }

    public ErrorDetail handleError(Throwable throwable, long cycle, long nanosIntoOp) {
        String errorName = this.namer.apply(throwable);
        List<ErrorHandler> handlers = this.handlerCache.get(errorName);
        ErrorDetail detail = ErrorDetail.ERROR_NONRETRYABLE;
        if (handlers == null) {
            handlers = this.lookup(errorName);
            this.handlerCache.put(errorName, handlers);
        }
        boolean retry = false;
        for (ErrorHandler handler : handlers) {
            detail = handler.handleError(errorName, throwable, cycle, nanosIntoOp, detail);
        }
        return detail;
    }

    private synchronized List<ErrorHandler> lookup(String errorName) {
        for (HandlerMapping config : this.configs) {
            for (Pattern errorPattern : config.matchers) {
                if (!errorPattern.matcher(errorName).matches()) continue;
                if (config.getResolved() == null) {
                    ArrayList<ErrorHandler> handlers = new ArrayList<ErrorHandler>();
                    for (Element handlerCfg : config.getHandlerCfgs()) {
                        ErrorHandler handler = this.getHandler(handlerCfg);
                        handlers.add(handler);
                    }
                    config.setResolved(handlers);
                }
                return config.getResolved();
            }
        }
        throw new RuntimeException("Unable to find a configured error handler for error '" + errorName + "'");
    }

    private ErrorHandler getHandler(Element cfg) {
        String name = (String)cfg.get("handler", String.class).orElseThrow();
        LinkedHashMap<String, ServiceLoader.Provider<ErrorHandler>> providers = NBErrorHandler.getProviders();
        ServiceLoader.Provider<ErrorHandler> provider = providers.get(name);
        if (provider == null) {
            throw new RuntimeException("ErrorHandler named '" + name + "' could not be found in " + providers.keySet());
        }
        ErrorHandler handler = provider.get();
        if (handler instanceof NBMapConfigurable) {
            ((NBMapConfigurable)handler).applyConfig(cfg.getMap());
        }
        if (handler instanceof ErrorMetrics.Aware) {
            ((ErrorMetrics.Aware)((Object)handler)).setErrorMetricsSupplier(this.errorMetricsSupplier);
        }
        return handler;
    }

    private static synchronized LinkedHashMap<String, ServiceLoader.Provider<ErrorHandler>> getProviders() {
        ServiceLoader<ErrorHandler> loader = ServiceLoader.load(ErrorHandler.class);
        LinkedHashMap<String, ServiceLoader.Provider<ErrorHandler>> providers = new LinkedHashMap<String, ServiceLoader.Provider<ErrorHandler>>();
        loader.stream().forEach(provider -> {
            Class type = provider.type();
            if (!type.isAnnotationPresent(Service.class)) {
                throw new RuntimeException("Annotator services must be annotated with distinct selectors\nsuch as @Service(Annotator.class,selector=\"myimpl42\")");
            }
            Service service = type.getAnnotation(Service.class);
            if (service.selector().isBlank()) {
                throw new RuntimeException("Services of type ErrorHandler must include the selector property in the Service annotation.");
            }
            providers.put(service.selector(), (ServiceLoader.Provider<ErrorHandler>)provider);
        });
        return providers;
    }

    public static class HandlerMapping {
        private static final Pattern pattern = Pattern.compile("((?<matchers>[\\w\\d-_.*+,]+):)?(?<handlers>.*)");
        private static final Pattern leadWord = Pattern.compile("(?<front>([^{},]+)|(\\{[^{}]+?\\}))(,(?<rest>.*))?");
        private final List<Pattern> matchers = new ArrayList<Pattern>();
        private final List<Element> params = new ArrayList<Element>();
        private List<ErrorHandler> resolved;

        public HandlerMapping(String spec) {
            String[] stringArray;
            Matcher matcher = pattern.matcher(spec);
            if (!matcher.matches()) {
                throw new RuntimeException("Unable to match pattern for handler spec with '" + spec + "'");
            }
            String gmatchers = matcher.group("matchers");
            String ghandlers = matcher.group("handlers");
            if (gmatchers != null) {
                stringArray = gmatchers.split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ".*";
            }
            String[] matcherspecs = stringArray;
            Arrays.stream(matcherspecs).map(Pattern::compile).forEach(this.matchers::add);
            while (ghandlers.length() > 0) {
                Matcher leadmatch = leadWord.matcher(ghandlers);
                if (leadmatch.matches()) {
                    String word = leadmatch.group("front");
                    ghandlers = leadmatch.group("rest") == null ? "" : leadmatch.group("rest");
                    Element next = null;
                    next = word.matches("\\d+") ? NBParams.one(null, (Object)("handler=code code=" + word)) : (word.matches("[a-zA-Z]+") ? NBParams.one(null, (Object)("handler=" + word)) : NBParams.one(null, (Object)word));
                    this.params.add(next);
                    continue;
                }
                throw new RuntimeException("Unable to get initial element from '" + gmatchers + "'");
            }
        }

        public List<Pattern> getErrorMatchers() {
            return this.matchers;
        }

        public List<Element> getHandlerCfgs() {
            return this.params;
        }

        public List<ErrorHandler> getResolved() {
            return this.resolved;
        }

        public void setResolved(List<ErrorHandler> resolved) {
            this.resolved = resolved;
        }
    }
}

