/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.planning;

import io.nosqlbench.engine.api.activityapi.planning.ElementSequencer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToLongFunction;

public class IntervalSequencer<T>
implements ElementSequencer<T> {
    @Override
    public int[] seqIndexByRatioFunc(List<T> elements, ToLongFunction<T> ratioFunc) {
        ArrayList<Long> ratios = new ArrayList<Long>();
        for (int i = 0; i < elements.size(); ++i) {
            T elem = elements.get(i);
            ratios.add(ratioFunc.applyAsLong(elem));
        }
        return this.seqIndexesByRatios(elements, ratios);
    }

    @Override
    public int[] seqIndexesByRatios(List<T> elems, List<Long> ratios) {
        ArrayList<OpSlot> ops = new ArrayList<OpSlot>();
        for (int i = 0; i < elems.size(); ++i) {
            T elem = elems.get(i);
            long freq = ratios.get(i);
            int p = 0;
            while ((long)p < freq) {
                double pos = (double)p / (double)freq;
                ops.add(new OpSlot<T>(elem, pos, i));
                ++p;
            }
        }
        ops.sort(new OpComparator());
        return ops.stream().mapToInt(OpSlot::getElementRank).toArray();
    }

    private static final class OpSlot<T> {
        private final T elem;
        private final double position;
        private final int rank;

        public OpSlot(T elem, double position, int rank) {
            this.elem = elem;
            this.position = position;
            this.rank = rank;
        }

        public T getElement() {
            return this.elem;
        }

        public int getElementRank() {
            return this.rank;
        }
    }

    private static final class OpComparator
    implements Comparator<OpSlot> {
        private OpComparator() {
        }

        @Override
        public int compare(OpSlot o1, OpSlot o2) {
            int timeOrder = Double.compare(o1.position, o2.position);
            if (timeOrder != 0) {
                return timeOrder;
            }
            return Integer.compare(o1.rank, o2.rank);
        }
    }
}

